% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_management.R
\name{setup_popular_models}
\alias{setup_popular_models}
\title{Quick Setup for Popular Models}
\usage{
setup_popular_models(models)
}
\arguments{
\item{models}{Character vector of model shortcuts to add. Available options:
\itemize{
  \item \code{"blip-base"}: BLIP base model for image captioning and VQA
  \item \code{"blip-large"}: BLIP large model for better performance
  \item \code{"align-base"}: ALIGN base model for image-text alignment
}}
}
\value{
Invisibly returns TRUE if all models added successfully
}
\description{
Convenience function to quickly add popular vision models with pre-configured settings.
}
\examples{
\dontrun{
# Add BLIP models for image captioning
setup_popular_models("blip-base")

# Add multiple experimental models at once
setup_popular_models(c("blip-base", "blip-large", "align-base"))

# Then use them in your analysis
list_vision_models()  # See all available models
result <- image_scores("image.jpg", c("happy", "sad"), model = "blip-base")
}
}
