% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rag_retrievers.R
\name{register_retriever}
\alias{register_retriever}
\title{Register a custom retriever}
\usage{
register_retriever(name, handler)
}
\arguments{
\item{name}{Character scalar; retriever name (e.g., "my_retriever").}

\item{handler}{Function with signature:
function(llama_index, documents, similarity_top_k,
         response_mode, params) -> engine_or_list
where the return value is either a Python query engine with `$query()`
or a list with element `query_fn` taking a single `query` argument
and returning a list with `response` and `source_nodes`.
Note: Settings are configured globally via llama_index.core.Settings.}
}
\description{
Registers a retriever under a name. The handler should construct and return
a query engine compatible with llama-index or a fallback with a `query_fn`.
}
