% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_findingemo.R
\name{map_to_emo8}
\alias{map_to_emo8}
\title{Map FindingEmo Emotions to Emo8 Labels}
\usage{
map_to_emo8(findingemo_emotions)
}
\arguments{
\item{findingemo_emotions}{Character vector of FindingEmo emotion labels to map.}
}
\value{
Character vector of mapped Emo8 emotion labels. Unmapped emotions return NA.
}
\description{
Maps FindingEmo dataset emotion labels to the standard 8 basic emotions 
(Emo8) from Plutchik's emotion wheel. This function converts complex emotion 
labels to the 8 fundamental emotions using intensity-based mappings from 
the circumplex model.
}
\details{
The mapping is based on Plutchik's circumplex model of emotions, where 
complex emotions are mapped to their corresponding basic emotions:

**Basic Emotions (direct mapping):**
- Joy, Trust, Fear, Surprise, Sadness, Disgust, Anger, Anticipation

**Intensity Variations:**
- High intensity: Ecstasy→Joy, Admiration→Trust, Terror→Fear, etc.
- Low intensity: Serenity→Joy, Acceptance→Trust, Apprehension→Fear, etc.

The 8 basic emotions (Emo8) are: joy, trust, fear, surprise, sadness, 
disgust, anger, anticipation.
}
\examples{
\dontrun{
# Map single emotions
map_to_emo8("Joy")           # "joy"
map_to_emo8("Ecstasy")       # "joy" 
map_to_emo8("Serenity")      # "joy"

# Map multiple emotions
findingemo_labels <- c("Joy", "Rage", "Terror", "Interest")
emo8_labels <- map_to_emo8(findingemo_labels)
# Returns: c("joy", "anger", "fear", "anticipation")

# Use in evaluation pipeline
annotations <- load_findingemo_annotations("./data")
annotations$emo8_label <- map_to_emo8(annotations$emotion)
}

}
