% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_clean.R
\name{fix_coords}
\alias{fix_coords}
\title{Fix and validate geographic coordinates (lat/lon)}
\usage{
fix_coords(df, lat = "lat", lon = "lon", divisor = 1e+07)
}
\arguments{
\item{df}{data.frame de entrada.}

\item{lat}{Nome da coluna de latitude (padrao: "lat").}

\item{lon}{Nome da coluna de longitude (padrao: "lon").}

\item{divisor}{Se abs(valor) exceder os limites, divide por este numero
(padrao 1e7).}
}
\value{
O \code{df} com \code{lat/lon} corrigidos quando presentes.
}
\description{
Normaliza latitude/longitude quando vierem em graus multiplicados por 1e7
(padrao de alguns exports de GPS) e invalida valores fora dos limites.
}
\examples{
# d <- data.frame(lat = -155432345, lon = -393212345)
# fix_coords(d)

}
