% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBLSFiles.R
\name{getBLSFiles}
\alias{getBLSFiles}
\title{Download and Process BLS Time Series Files with Vectorized Date Assignment}
\usage{
getBLSFiles(data_source, email)
}
\arguments{
\item{data_source}{A character string specifying the data source. One of \code{"cpi"},
\code{"eci"}, \code{"jolts"}, \code{"cps"}, \code{"ces"}, \code{"averageprice"}, or \code{"food"}.}

\item{email}{A character string containing your email address. This is used as the HTTP
user agent when downloading files.}
}
\value{
A tibble containing the merged BLS data with an assigned date column.
}
\description{
This function downloads and processes data from the Bureau of Labor Statistics (BLS)
for a given data source. It downloads several auxiliary files, merges them to enrich
series metadata, downloads the main data file, and assigns dates based on the period
code. For monthly data (codes "M01"–"M12") the date is set to the first day of the month;
if the period is "M13", the date is set to December 31; and for quarterly data (codes
"Q1"–"Q4") the date is assigned as the last day of the quarter's final month.
}
\examples{
\donttest{
  # Download CPI data using your email address
  bls_data <- getBLSFiles("cpi", "user@example.com")
}

}
