% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-misc.R
\name{add_histogram}
\alias{add_histogram}
\title{Add histogram}
\usage{
add_histogram(plot, binwidth = NULL, bins = NULL, ...)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{binwidth}{The width of the bins. Can be specified as a numeric value
or as a function that takes x after scale transformation as input and
returns a single numeric value. When specifying a function along with a
grouping structure, the function will be called once per group.
The default is to use the number of bins in \code{bins},
covering the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.

The bin width of a date variable is the number of days in each time; the
bin width of a time variable is the number of seconds.}

\item{bins}{Number of bins. Overridden by \code{binwidth}. Defaults to 30.}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add histogram
}
\examples{
energy |>
  tidyplot(x = energy) |>
  add_histogram()

energy |>
  tidyplot(x = energy, color = energy_type) |>
  add_histogram()

}
