% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_style_plan.R
\name{col_style_structure}
\alias{col_style_structure}
\title{Column Style Structure}
\usage{
col_style_structure(
  col,
  align = NULL,
  type = c("char", "pos"),
  width = NULL,
  ...
)
}
\arguments{
\item{col}{Column value to align on from \code{column} variable. May be a quoted
or unquoted column name, a tidyselect semantic, or a span_structure.}

\item{align}{Alignment to be applied to column. Defaults to \code{left} alignment. See details for acceptable values.}

\item{type}{Type of alignment: "char" or "pos", for character alignment (default), and positional alignment, respectively. Positional alignment allows for aligning over multiple positions in the column.}

\item{width}{Width to apply to the column in number of characters. Acceptable values include a
numeric value, or a character string of a number.}

\item{...}{These dots are for future extensions and must be empty}
}
\value{
col_style_structure object
}
\description{
Column Style Structure
}
\details{
Supports alignment and width setting of data value columns (values found in the \code{column} column). Row group and label columns are left-aligned by default. Acceptable input values for \code{align} differ by type = "char" or "pos":
\subsection{Character alignment (type = "char"):}{
\itemize{
\item "left" for left alignment
\item "right" for right alignment"
\item supply a vector of character(s) to align on. If more than
one character is provided, alignment will be based on the first occurrence
of any of the characters. For alignment based on white space, leading white
spaces will be ignored.
}
}

\subsection{Positional alignment (type = "pos"):}{

supply a vector of strings covering all formatted cell values, with numeric values represented as x's. These values can be created manually or obtained by utilizing the helper \code{display_val_frmts()}. Alignment positions will be represented by vertical bars. For example, with starting values: c("12.3", "(5\%)", "2.35 (10.23)") we can align all of the first sets of decimals and parentheses by providing align = c("xx|.x", "||(x\%)", "x|.xx |")
}
}
\examples{

 plan <- col_style_plan(
    col_style_structure(col = "my_var",
                        align = c("xx| |(xx\%)",
                                  "xx|.x |(xx.x - xx.x)"),
                        type = "pos", width = 100),
    col_style_structure(col = vars(four), align = "right", width = 200),
    col_style_structure(col = vars(two, three), align = c(".", ",", " ")),
    col_style_structure(col = c(two, three), width = 25),
    col_style_structure(col = two, width = 25),
    col_style_structure(col = span_structure(span = value, col = val2),
                        width = 25)
   )

}
\seealso{
\code{\link[=col_style_plan]{col_style_plan()}} for more information on how to combine
col_style_structure()'s together to form a plan.

\href{https://gsk-biostatistics.github.io/tfrmt/articles/col_style_plan.html}{Link to related article}
}
