% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagpol.R, R/tf.R, R/um.R
\name{roots}
\alias{roots}
\alias{roots.default}
\alias{roots.lagpol}
\alias{roots.tf}
\alias{roots.um}
\title{Roots of lag polynomials}
\usage{
roots(x, ...)

\method{roots}{default}(x, ...)

\method{roots}{lagpol}(x, table = TRUE, tol = 1e-05, ...)

\method{roots}{tf}(x, opr = c("arma", "ar", "ma"), ...)

\method{roots}{um}(x, opr = c("arma", "ar", "ma", "i", "arima"), ...)
}
\arguments{
\item{x}{A model object containing lag polynomials ("um", "tfm") or 
a lag polynomial object ("lagpol").}

\item{...}{Additional arguments passed to methods.}

\item{table}{Logical. If TRUE returns detailed table, if FALSE complex vector.}

\item{tol}{Tolerance for identifying distinct roots.}

\item{opr}{character. Operators for which roots are computed. Options: "arma",
"arma", "ar", "ma", "i" or "arima".}
}
\value{
Returns a summary table with the roots of each \code{lagpol}.
}
\description{
\code{roots} computes the roots of lag polynomials from polynomial objects and 
time series models that contain lag polynomials as components.
}
\examples{
roots(c(1, 1.2, -0.8))
um1 <- um(ar = "(1 - 0.8B)(1 - 0.8B^12)")
roots(um1)
}
