% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ucarima.R
\name{fit.ucarima}
\alias{fit.ucarima}
\title{Estimation of UCARIMA models}
\usage{
\method{fit}{ucarima}(mdl, z = NULL, method = "BFGS", show.iter = FALSE, envir = NULL, ...)
}
\arguments{
\item{mdl}{An object of class \code{\link{ucarima}}.}

\item{z}{Optional. A time series object (\code{ts}) used for estimation if
not already included in \code{mdl}.}

\item{method}{Character string specifying the optimization method passed to 
\code{\link[stats]{optim}}. Default is \code{"BFGS"}.}

\item{show.iter}{Logical. If \code{TRUE}, displays parameter estimates during
each iteration of the optimization process. Default is \code{FALSE}.}

\item{envir}{Environment where the estimation is evaluated. If \code{NULL}
(default), uses the parent environment.}

\item{...}{Additional arguments passed to \code{\link[stats]{optim}}.}
}
\value{
An updated \code{ucarima} object with estimated parameters,
  log-likelihood, and convergence information.
}
\description{
Estimates the parameters of a UCARIMA model using maximum likelihood.
}
\examples{
# Define a local level model with trend and irregular components
trend <- um(i = 1, sig2 = c(s2t = 0.5))
irreg <- um(sig2 = c(s2i = 1))

# Create and estimate the UCARIMA model
uca <- ucarima(ucm = list(trend = trend, irreg = irreg))
uca_fitted <- fit(uca, Nile)

}
