% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{sd_create_messages}
\alias{sd_create_messages}
\title{Create a messages template file}
\usage{
sd_create_messages(language = "en", path = getwd())
}
\arguments{
\item{language}{Character string specifying the language to use. See
https://shiny.posit.co/r/reference/shiny/1.7.0/dateinput for supported
languages. Also, if \code{"en"}, \code{"de"}, \code{"es"}, \code{"fr"}, or \code{"it"} is chosen,
default messages in those langauges will be used, otherwise the default
English messages will be used. Defaults to \code{"en"}.}

\item{path}{Character string specifying the directory where the messages.yml
file should be created. Defaults to the current working directory. The
file should be placed in the root project folder of your surveydown survey.}
}
\value{
Invisible \code{NULL}.
}
\description{
This function creates a template messages.yml file in the project root directory
that users can customize to modify system messages.
}
\examples{
if (interactive()) {
  # Create English template
  sd_create_messages()

  # Create German template
  sd_create_messages(language = "de")

  # Create Japanese template
  # Will use English messages but Japanese date picker - user can modify
  # the messages as desired
  sd_create_messages(language = "ja")
}
}
