% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.ratio.mean2}
\alias{size.ci.ratio.mean2}
\title{Sample size for a 2-group mean ratio confidence interval}
\usage{
size.ci.ratio.mean2(alpha, var, m1, m2, r, R)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{var}{planning value of average within-group variance}

\item{m1}{planning value of mean for group 1}

\item{m2}{planning value of mean for group 2}

\item{r}{desired upper to lower confidence interval endpoint ratio}

\item{R}{n2/n1 ratio}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group required to estimate a ratio of
population means with desired confidence interval precision in a 2-group
design. This function requires planning values for each mean and the sample
size requirement is very sensitive to these planning values. Set the
variance planning value to the largest value within a plausible range for a
conservatively large sample size. Set R = 1 for equal sample sizes. For
unequal sample sizes, this function assumes approximately equal population
variances.

For more details, see Section 2.13 of Bonett (2021, Volume 1)
}
\examples{
size.ci.ratio.mean2(.05, .4, 3.5, 3.1, 1.2, 1)

# Should return:
# n1   n2
# 70   70

size.ci.ratio.mean2(.05, .4, 3.5, 3.1, 1.2, 2)

# Should return:
# n1   n2
# 53  106
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
