% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_statis.R
\name{plot.statis.circle}
\alias{plot.statis.circle}
\title{Plot a Correlation Circle (Unit Circle)}
\usage{
\method{plot}{statis.circle}(points, inertia = 100, labels = NULL, title = "")
}
\arguments{
\item{points}{A matrix or data frame with two numeric columns (x, y) representing the coordinates of the vectors.}

\item{inertia}{A number between 0 and 100 representing the percentage of explained inertia. It is displayed in the title.}

\item{labels}{A character vector with labels for the points (optional). If not specified, labels are left blank.}

\item{title}{Optional text used as the main title of the plot.}
}
\value{
A \code{ggplot} object with the generated plot.
}
\description{
This function generates a correlation circle plot from two-dimensional coordinates,
commonly used in principal component analysis (PCA) or other multivariate methods.
}
\details{
Arrows are drawn from the origin to each point specified in \code{points}. A reference circle
with radius 1 is displayed. You can also show the percentage of explained inertia and point labels.

The \code{inertia} argument is flexible and can be passed as the second or third parameter
if argument names are omitted.
}
\examples{
data(expert1, expert2, expert3)

labels <- c("Expert 1", "Expert 2", "Expert 3")

# If you want to select an specific table or row just set the parameters in the statis function.

res <- statis(list(expert1, expert2, expert3), table.labels = labels)

# Circle of correlations of all the tables
inter <- res$circle.inter
plot.statis.circle(inter$points, inter$inertia, inter$labels, inter$title)

# Circle of correlations of all variables evolution
intra <- res$circle.intra
plot.statis.circle(intra$points, intra$inertia, intra$labels, intra$title)

}
\seealso{
\code{\link{statis}}
}
