% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_src.R
\name{srcr}
\alias{srcr}
\title{Connect to database using config file}
\usage{
srcr(
  basenames = NA,
  dirs = NA,
  suffices = NA,
  paths = NA,
  config = NA,
  allow_post_connect = getOption("srcr.allow_post_connect", c()),
  allow_config_code = getOption("srcr.allow_config_code", allow_post_connect)
)
}
\arguments{
\item{basenames}{A vector of file names (without directory or file type) to
use in searching for configuration files.}

\item{dirs}{A vector of directory names to use in searching for configuration
files.}

\item{suffices}{A vector of suffices (file "type"s) to use in searching for
the configuration file.}

\item{paths}{A vector of full path names for the configuration file.  If
present, only these paths are checked; \code{\link[=find_config_files]{find_config_files()}} is not called.}

\item{config}{A list containing the configuration data, to be used instead of
reading a configuration file, should you wish to skip that step.}

\item{allow_post_connect}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This has been superseded by the more  generally functional
\code{allow_config_code} parameter.  It currently generates a warning when used,
and will be removed in a future version.}

\item{allow_config_code}{A vector specifying what session setup you will
permit via code contained in the config.  If any element of the vector
is \code{sql}, then the post_connect_sql section of the configuration file is
executed aftern the connection is established. If any element is \code{fun},
then the pre- and post-connection functions will be executed (see above).}
}
\value{
A database connection.  The specific class of the object is determined
by the \code{src_name} in the configuration data.
}
\description{
Set up a or DBI or legacy dplyr database connection using information from a
JSON configuration file, and return the connection.
}
\details{
The configuration file must provide all of the information necessary to set
up the DBI connection or dplyr src.  Given the variety of ways a data source
can be specified, the JSON must be a hash containing at least two elements:
\itemize{
\item The \code{src_name} key typically points to a string containing name of a DBI
driver method (e.g. \code{SQLite}), as one might pass to \code{\link[DBI:dbDriver]{DBI::dbDriver()}}.
In this case, an attempt will be made to load the appropriate DBI-compliant
database library (e.g. RSQLite for the above example) if it hasn't already
been loaded. If the value associated with \code{src_name} begins with 'src_',
it is taken as the name of a function to call directly, rather than a DBI
class name.
\item The \code{src_args} key points to a nested hash, whose keys are the arguments
to that function, and whose values are the argument values.
}

To locate the necessary configuration file, you can use all of the arguments
taken by \code{\link[=find_config_files]{find_config_files()}}, but remember that the contents of the file
must be JSON, regardless of the file's name.  Alternatively, if \code{paths} is
present, only the specified paths are checked. The first file that exists, is
readable, and evaluates as legal JSON is used as the source of configuration
data.

If your deployment strategy does not make use of configuration files (e.g. you
access configuration data via a web service or similar API), you may also
pass a list containing the configuration data directly via the \code{config}
parameter.  In this case, no configuration files are used.

Because some uses may require additional actions, such as setting up
environment variables, external authentication, or initialization work within
the database session, you may include code to be executed in your
configuration file.  The \code{pre_connect_fun} element, if present, should be an
array of text that will be joined linewise and evaluated as R source code. It
must define an anonymouis function which will be called with one argument,
the content of the config file.  If this function returns a DBI connection,
the srcr will skip the default process for creating a connection and use this
instead. Any other non-NA return value replaces the configuration data
originally read from the file during further steps.  Once the connection is
established, the \code{post_connect_sql} and \code{post_connect_fun} elements of the
configuration data can be used to perform  additional processing to set
session characteristics, roles, etc.  However,  because this entails the
configuration file providing code that you won't see  prior to runtime, you
need to opt in to these features.  You can make this choice globally by
setting the \code{srcr.allow_config_code} option via  \code{\link[base:options]{base::options()}}, or you
can enable it on a per-call basis with the \code{allow_config_code} parameter.
}
\examples{
\dontrun{
# Search all the (filename-based) defaults
srcr()

# "The usual"
srcr('myproj_prod')

# Look around
srcr(dirs = c(Sys.getenv('PROJ_CONF_DIR'), 'var/lib', getwd()),
     basenames = c('myproj', Sys.getenv('PROJ_NAME')) )

# No defaults
srcr(paths = c('/path/to/known/config.json'))
srcr(config =
       list(src_name = 'Postgres',
            src_args = list(host = 'my.host', dbname = 'my_db', user = 'me'),
            post_connect_sql = 'set role project_role;'),
            allow_config_code = 'sql')
}
}
