% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{plants_rf}
\alias{plants_rf}
\title{Example fitted random forest model}
\format{
An object of class \code{rf} fitted with the following parameters:
\itemize{
\item \code{data}: \link{plants_df}
\item \code{dependent.variable.name}: \link{plants_response} ("richness_species_vascular")
\item \code{predictor.variable.names}: \link{plants_predictors} (17 variables)
\item \code{distance.matrix}: \link{plants_distance}
\item \code{xy}: \link{plants_xy}
\item \code{distance.thresholds}: \code{c(100, 1000, 2000, 4000)}
\item \code{num.trees}: 50
\item \code{min.node.size}: 30
\item \code{n.cores}: 1
}
}
\usage{
data(plants_rf)
}
\description{
Fitted random forest model using \link{plants_df}. Provided for testing and examples without requiring model fitting. Fitted with reduced complexity for faster computation and smaller object size.
}
\details{
This model uses reduced complexity (50 trees, min.node.size = 30) to keep object size small for package distribution. For actual analyses, use higher values (e.g., num.trees = 500, min.node.size = 5).
}
\seealso{
\code{\link[=rf]{rf()}}, \link{plants_df}, \link{plants_response}, \link{plants_predictors}

Other data: 
\code{\link{plants_df}},
\code{\link{plants_distance}},
\code{\link{plants_predictors}},
\code{\link{plants_response}},
\code{\link{plants_rf_spatial}},
\code{\link{plants_xy}}
}
\concept{data}
\keyword{datasets}
