% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_spatial_predictors.R
\name{get_spatial_predictors}
\alias{get_spatial_predictors}
\title{Extract spatial predictors from spatial model}
\usage{
get_spatial_predictors(model)
}
\arguments{
\item{model}{Model object from \code{\link[=rf_spatial]{rf_spatial()}} (must have class \code{rf_spatial}).}
}
\value{
Data frame containing the spatial predictor values for each observation, with predictors ordered by decreasing importance.
}
\description{
Extracts the spatial predictors (Moran's Eigenvector Maps) used in a model fitted with \code{\link[=rf_spatial]{rf_spatial()}}.
}
\details{
Spatial predictors are Moran's Eigenvector Maps (MEMs) automatically generated and selected by \code{\link[=rf_spatial]{rf_spatial()}} to capture spatial autocorrelation patterns in the data. This function extracts these predictors, which can be useful for understanding spatial structure or for making predictions on new spatial locations.
}
\examples{
data(plants_rf_spatial)

# Extract spatial predictors
spatial_preds <- get_spatial_predictors(plants_rf_spatial)
head(spatial_preds)

# Check dimensions
dim(spatial_preds)

# View predictor names (ordered by importance)
colnames(spatial_preds)

}
\seealso{
\code{\link[=rf_spatial]{rf_spatial()}}, \code{\link[=mem]{mem()}}, \code{\link[=mem_multithreshold]{mem_multithreshold()}}, \code{\link[=get_importance]{get_importance()}}

Other model_info: 
\code{\link{get_evaluation}()},
\code{\link{get_importance}()},
\code{\link{get_importance_local}()},
\code{\link{get_moran}()},
\code{\link{get_performance}()},
\code{\link{get_predictions}()},
\code{\link{get_residuals}()},
\code{\link{get_response_curves}()},
\code{\link{print.rf}()},
\code{\link{print_evaluation}()},
\code{\link{print_importance}()},
\code{\link{print_moran}()},
\code{\link{print_performance}()}
}
\concept{model_info}
