% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_response_curves.R
\name{get_response_curves}
\alias{get_response_curves}
\title{Extract response curve data for plotting}
\usage{
get_response_curves(
  model = NULL,
  variables = NULL,
  quantiles = c(0.1, 0.5, 0.9),
  grid.resolution = 200,
  verbose = TRUE
)
}
\arguments{
\item{model}{Model object from \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}

\item{variables}{Character vector of predictor names to plot. If \code{NULL}, automatically selects the top 50\% most important variables. Default: \code{NULL}.}

\item{quantiles}{Numeric vector of quantiles (0 to 1) at which to fix non-plotted predictors. Multiple quantiles show response variation under different scenarios. Default: \code{c(0.1, 0.5, 0.9)}.}

\item{grid.resolution}{Integer (20 to 500) specifying the number of points along the predictor axis. Higher values produce smoother curves. Default: \code{200}.}

\item{verbose}{Logical. If \code{TRUE}, prints progress messages. Default: \code{TRUE}.}
}
\value{
Data frame with the following columns:
\itemize{
\item \code{response}: Predicted response values.
\item \code{predictor}: Predictor values along the gradient.
\item \code{quantile}: Factor indicating which quantile was used to fix other predictors.
\item \code{model}: Model index (only for \code{\link[=rf_repeat]{rf_repeat()}} models with multiple repetitions).
\item \code{predictor.name}: Character name of the focal predictor.
\item \code{response.name}: Character name of the response variable.
}
}
\description{
Extracts data for plotting partial dependence (response) curves showing how predictions vary with each predictor from models fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.
}
\details{
Response curves (also called partial dependence plots) show how predicted values change as a focal predictor varies while holding other predictors constant at specified quantile values. This reveals the marginal effect of each predictor.

The function generates curves by:
\enumerate{
\item Creating a grid of values for the focal predictor
\item Fixing non-plotted predictors at each quantile (e.g., 0.1, 0.5, 0.9)
\item Predicting responses across the grid
\item Repeating for each selected predictor and quantile combination
}

Multiple quantiles reveal whether the effect of a predictor is consistent across different environmental contexts (parallel curves) or varies depending on other conditions (non-parallel curves).
}
\examples{
data(plants_rf)

# Extract response curve data for plotting
curves <- get_response_curves(
  model = plants_rf,
  variables = NULL,  # auto-select important variables
  quantiles = c(0.1, 0.5, 0.9)
)

# View structure
head(curves)
str(curves)

# Check unique predictors included
unique(curves$predictor.name)

}
\seealso{
\code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, \code{\link[=rf_spatial]{rf_spatial()}}, \code{\link[=plot_response_curves]{plot_response_curves()}}, \code{\link[=get_importance]{get_importance()}}

Other model_info: 
\code{\link{get_evaluation}()},
\code{\link{get_importance}()},
\code{\link{get_importance_local}()},
\code{\link{get_moran}()},
\code{\link{get_performance}()},
\code{\link{get_predictions}()},
\code{\link{get_residuals}()},
\code{\link{get_spatial_predictors}()},
\code{\link{print.rf}()},
\code{\link{print_evaluation}()},
\code{\link{print_importance}()},
\code{\link{print_moran}()},
\code{\link{print_performance}()}
}
\concept{model_info}
