% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsp.R
\name{hsp}
\alias{hsp}
\title{Hierarchical Slope Position}
\usage{
hsp(
  x,
  min.scale = 3,
  max.scale = 27,
  inc = 4,
  win = "rectangle",
  normalize = FALSE
)
}
\arguments{
\item{x}{A terra SpatRaster class object}

\item{min.scale}{Minimum scale (window size)}

\item{max.scale}{Maximum scale (window size)}

\item{inc}{Increment to increase scales}

\item{win}{Window type, options are "rectangle" or "circle"}

\item{normalize}{Normalize results to 0-1 scale (FALSE | TRUE)}
}
\value{
terra SpatRaster class object of slope position
}
\description{
Calculates a hierarchical scale decomposition of topographic 
position index
}
\details{
if win  = "circle" units are distance, if win = "rectangle" units 
are number of cells
}
\examples{
\donttest{ 
  library(terra)
  elev <- rast(system.file("extdata/elev.tif", package="spatialEco"))
  hsp27 <- hsp(elev, 3, 27, 4, normalize = TRUE)
  plot(hsp27)
 }

}
\references{
Murphy M.A., J.S. Evans, and A.S. Storfer (2010) Quantify Bufo boreas 
  connectivity in Yellowstone National Park with landscape genetics. 
  Ecology 91:252-261
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
