% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FungusTreeNetwork.R
\docType{data}
\name{FungusTreeNetwork}
\alias{FungusTreeNetwork}
\title{FungusTreeNetwork}
\format{
A list of two elements, networks and sbmResults.

networks is itself a list with the following entries:
\describe{
     \item{tee_names:}{(character) tree names}
     \item{fungus_names:}{(character) fungus names}
     \item{tree_tree:}{a list describing the unipartite tree_tree networks with nodes (data.frame), edges (data.frame) and type (character specifying the type of the network)}
     \item{fungus_tree:}{a list describing the bipartite fungus_tree networks with nodes (data.frame), edges (data.frame) and type (character)}
          }
sbmResults is a list with the following entries:
\describe{
     \item{tree_tree}{Results of \code{sbm::estimateSimpleSBM}
     applied on tree_tree data with a Poisson model.}
     \item{fungus_tree}{Results of \code{sbm::estimateBipartiteSBM}
     applied on fungus_tree data with a Bernoulli model.}
}
}
\source{
Vacher, Corinne, Dominique Piou, and Marie-Laure Desprez-Loustau. "Architecture of an antagonistic tree/fungus network: the asymmetric influence of past evolutionary history." PloS one 3.3 (2008): e1740.
}
\usage{
FungusTreeNetwork
}
\description{
fungus-tree interaction network

This data set provides information about 154 fungi sampled on 51 tree species.
Composed of nodes and edges lists build based on \pkg{sbm} data package.
}
\keyword{datasets}
