% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_ests_barplot.R
\name{strat_ests_barplot}
\alias{strat_ests_barplot}
\title{Barplot method for \code{summary.seroincidence.by} objects}
\usage{
strat_ests_barplot(
  object,
  yvar,
  color_var = NULL,
  alpha = 0.7,
  CIs = FALSE,
  title = NULL,
  xlab = "Seroconversion rate per 1000 person-years",
  ylab = yvar,
  fill_lab = NULL,
  color_palette = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{summary.seroincidence.by} object (generated by applying the
\code{summary()} method to the output of \code{\link[=est_seroincidence_by]{est_seroincidence_by()}}).}

\item{yvar}{the name of a stratifying variable in \code{object}.}

\item{color_var}{\link{character} the name of the fill color variable (e.g., "Country").}

\item{alpha}{transparency for the bars (1 = no transparency, 0 = fully transparent).}

\item{CIs}{\link{logical}, if \code{TRUE}, add CI error bars.}

\item{title}{a title for the final plot.}

\item{xlab}{a label for the x-axis of the final plot.}

\item{ylab}{a label for the y-axis of the final plot.}

\item{fill_lab}{fill label.}

\item{color_palette}{optional color palette for bar color.}

\item{...}{unused.}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Barplot method for \code{summary.seroincidence.by} objects
}
\keyword{internal}
