% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_publisher_apps.R
\name{st_publisher_apps}
\alias{st_publisher_apps}
\title{Get All Apps from a Publisher}
\usage{
st_publisher_apps(
  unified_id = NULL,
  publisher_id = NULL,
  aggregate_related = FALSE,
  auth_token = Sys.getenv("SENSORTOWER_AUTH_TOKEN"),
  verbose = TRUE
)
}
\arguments{
\item{unified_id}{Character. Unified ID to resolve apps for. May be either:
- Unified Publisher ID (24-char hex)
- Unified App ID (24-char hex) belonging to a publisher
The API returns the unified publisher and all associated apps in both cases.}

\item{publisher_id}{Deprecated alias for `unified_id`.}

\item{aggregate_related}{Logical. If TRUE, ensures each app's unified_app_id
is the canonical ID that aggregates ALL regional SKUs. This solves the problem
where games like "Watcher of Realms" are published under multiple regional
publishers (Moonton, Vizta Games, Skystone Games, etc.) and may return
different unified_app_ids. When TRUE, the function looks up each app by name
to find the true unified_app_id that combines all regional versions.
Defaults to FALSE for backwards compatibility.}

\item{auth_token}{Character. Your Sensor Tower API authentication token.
Defaults to the value stored in the `SENSORTOWER_AUTH_TOKEN` environment
variable.}

\item{verbose}{Logical. If TRUE, prints progress messages during aggregation.
Defaults to TRUE.}
}
\value{
A [tibble][tibble::tibble] containing details of the apps associated
  with the publisher. The exact columns depend on the API response but often
  include app IDs, names, platform, etc. Returns an empty tibble if the
  publisher ID is invalid, has no apps, or an error occurs.
}
\description{
Retrieves a list of apps associated with a specified unified publisher ID
from the Sensor Tower API. Targets the `/v1/unified/publishers/apps`
endpoint.
}
\section{Solving Regional Publisher Issues}{

Many publishers have regional subsidiaries or partners that publish the same
game under different app IDs in different regions. For example, Moonton's
"Watcher of Realms" is published by Moonton in some regions, Vizta Games in
others, and Skystone Games in others.

When `aggregate_related = TRUE`, this function ensures you get the unified_app_id
that represents the FULL game across all regional publishers, which is required
for accurate revenue/download aggregation via `st_unified_sales_report()`.
}

\section{API Endpoint Used}{

  - `GET /v1/unified/publishers/apps`
}

\examples{
\dontrun{
# Ensure SENSORTOWER_AUTH_TOKEN is set in your environment
# Sys.setenv(SENSORTOWER_AUTH_TOKEN = "your_secure_auth_token_here")

# Basic usage - get publisher's apps
apps_list <- st_publisher_apps(unified_id = "647eb849d9d91f31a54f1792")

# With regional SKU aggregation - ensures canonical unified_app_ids
apps_list <- st_publisher_apps(
  unified_id = "647eb849d9d91f31a54f1792",
  aggregate_related = TRUE
)

# Then use with st_unified_sales_report() for accurate data
sales <- st_unified_sales_report(
  unified_app_id = apps_list$unified_app_id,
  countries = "WW",
  start_date = "2024-01-01",
  end_date = "2024-12-31",
  date_granularity = "monthly"
)
}

}
