% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generator.R
\name{generate_test_data}
\alias{generate_test_data}
\title{Generate simulated data for testing}
\usage{
generate_test_data(
  n_units = 20,
  n_periods = 30,
  treatment_start = 20,
  effect_size = -5
)
}
\arguments{
\item{n_units}{Number of units}

\item{n_periods}{Number of time periods}

\item{treatment_start}{When treatment begins}

\item{effect_size}{Size of treatment effect}
}
\value{
A numeric matrix with dimensions (n_periods x n_units).
  The first column represents the treated unit, remaining columns are
  control units. Rows represent time periods.
}
\description{
Generate simulated data for testing
}
\examples{
# Generate test data with default parameters
data <- generate_test_data()
dim(data)  # 30 periods x 20 units

# Generate smaller dataset
data <- generate_test_data(n_units = 10, n_periods = 20,
                           treatment_start = 15, effect_size = -3)
}
