% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanTech.r
\name{meanTech}
\alias{meanTech}
\title{Calculate mean of technical replicates}
\usage{
meanTech(x, groups)
}
\arguments{
\item{x}{A raw data frame containing technical replicates.}

\item{groups}{An integer vector or character vector specifying the column(s) to group
by before calculating the mean of technical replicates.}
}
\value{
A data frame with the mean of technical replicates for each group.
}
\description{
Computes the arithmetic mean of technical replicates for each sample or group.
This is often performed before ANOVA or other statistical analyses to simplify
comparisons between experimental groups.
}
\details{
The \code{meanTech} function calculates the mean of technical replicates
based on one or more grouping columns. This reduces the dataset to a single
representative value per group, facilitating downstream analysis such as
fold change calculation or ANOVA.
}
\examples{

# Example input data frame with technical replicates
data_withTechRep

# Calculate mean of technical replicates using first four columns as groups
meanTech(data_withTechRep, groups = 1:4)

# Another example using different dataset and grouping columns
meanTech(Lee_etal2020qPCR, groups = 1:3)
}
\author{
Ghader Mirzaghaderi
}
