% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confband.R
\name{confband}
\alias{confband}
\title{Add confidence bands to estimated Rt or incidence curves}
\usage{
confband(object, lambda, level = 0.95, type = c("Rt", "Yt"), ...)
}
\arguments{
\item{object}{a \code{poisson_rt} or \code{cv_poisson_rt} object.}

\item{lambda}{the selected lambda. May be a scalar value, or in the case of
\code{cv_poisson_rt} objects, \code{"lambda.min"} or \code{"lambda.max"}.}

\item{level}{the desired confidence level(s). These will be sorted if
necessary.}

\item{type}{the type \code{Rt} or \code{Yt} for confidence intervals of fitted
Rt or fitted incident cases}

\item{...}{additional arguments for methods. Unused.}
}
\value{
A \code{data.frame} containing the estimates \code{Rt} or \code{Yt} at the chosen
\code{lambda}, and confidence limits corresponding to \code{level}
}
\description{
Create an approximate confidence band for the Rt or incidence estimate. Note
that the variance computation is approximate.
}
\examples{
y <- c(1, rpois(100, dnorm(1:100, 50, 15) * 500 + 1))
out <- estimate_rt(y, nsol = 10)
head(confband(out, out$lambda[2]))
head(confband(out, out$lambda[2], level = c(0.95, 0.8, 0.5)))

cv <- cv_estimate_rt(y, nfold = 3, nsol = 30)
head(confband(cv, "lambda.min", c(0.5, 0.9)))
}
