test_that("get_phylopic works", {
  skip_if_offline(host = "api.phylopic.org")
  # uuid
  uuid <- "9fae30cd-fb59-4a81-a39c-e1826a35f612"

  # Expect true
  expect_true(is(get_phylopic(uuid = uuid, format = "vector"), "Picture"))
  expect_true(is(get_phylopic(uuid = uuid, format = "raster"), "array"))
  expect_true(is(get_phylopic(uuid = uuid, format = "raster",
                              height = 300), "array"))
  expect_true(is(get_phylopic(uuid = uuid, format = "vector", source = TRUE),
                 "Picture"))
  expect_true(is(get_phylopic(uuid = uuid, format = "raster", source = TRUE),
                 "array"))

  expect_no_error(get_phylopic(uuid = uuid, preview = TRUE))

  # Expect error
  expect_error(get_phylopic(uuid = 1))
  expect_error(get_phylopic(uuid = c("1", 2)))
  expect_error(get_phylopic(uuid = NULL))
  expect_error(get_phylopic(uuid = uuid, format = "VHS"))
  expect_error(get_phylopic(uuid = uuid, preview = "yes"))
  # 512 was deprecated for format
  expect_error(get_phylopic(uuid = "c8f71c27-71db-4b34-ac2d-e97fea8762cf",
                            format = "512"))
})
