% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_simulation.R
\name{add_fixed_effect}
\alias{add_fixed_effect}
\title{Add a fixed effect column for simulation}
\usage{
add_fixed_effect(design_df, ...)
}
\arguments{
\item{design_df}{A data frame containing the rollout design and any parameters.}

\item{...}{A single named expression specifying the fixed effect to add (e.g., \code{beta = 0.5 * x}).}
}
\value{
A \code{tibble} with the added fixed effect column.
}
\description{
Adds a fixed effect column (prefixed with \code{"."}) to the design data frame for simulation purposes.
}
\examples{
df <- tibble::tibble(x = rnorm(5))
add_fixed_effect(df, beta = 0.5 * x)
}
