% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_seasonality.R
\name{seasonality_modified_qs}
\alias{seasonality_modified_qs}
\title{Modified QS Seasonality Test (Maravall)}
\usage{
seasonality_modified_qs(data, period = NA, nyears = 0)
}
\arguments{
\item{data}{the input data.}

\item{period}{Tested periodicity. Can be missing if the input is a time series}

\item{nyears}{Number of periods or number of cycles considered in the test, at the end of the series:
in periods (positive value) or years (negative values).
By default (\code{nyears = 0}), the entire sample is used.}
}
\value{
The value of the test
}
\description{
Modified QS Seasonality Test (Maravall)
}
\details{
Thresholds for p-values: p.9=2.49, p.95=3.83, p.99=7.06, p.999=11.88.
Computed on 100.000.000 random series (different lengths).
Remark: the length of the series has some impact on the p-values, mainly on
short series. Not critical.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
s <- do_stationary(log(ABS$X0.2.09.10.M))$ddata
seasonality_modified_qs(s)
\dontshow{\}) # examplesIf}
}
