% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_regular.R
\name{autocorrelations}
\alias{autocorrelations}
\alias{autocorrelations_partial}
\alias{autocorrelations_inverse}
\title{Autocorrelation Functions}
\usage{
autocorrelations(data, mean = TRUE, n = 15)

autocorrelations_partial(data, mean = TRUE, n = 15)

autocorrelations_inverse(data, nar = 30, n = 15)
}
\arguments{
\item{data}{data being tested.}

\item{mean}{Mean correction. If \code{TRUE}, the auto-correlations are computed as usual.
If \code{FALSE}, we consider that the (known) mean is 0 and that the series has been corrected for it.}

\item{n}{maximum lag at which to calculate the stats.}

\item{nar}{number of AR lags used to compute inverse autocorrelations.}
}
\value{
\code{autocorrelations()} returns a vector of length \code{n} with
the autocorrelations.
\code{autocorrelations_partial()} returns a vector of length \code{n} with
the partial autocorrelations.
\code{autocorrelations_inverse()} returns a vector of length \code{n} with
the inverse autocorrelations.
}
\description{
Autocorrelation Functions
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
x <- ABS$X0.2.09.10.M
autocorrelations(x)
autocorrelations_partial(x)
autocorrelations_inverse(x)
\dontshow{\}) # examplesIf}
}
