/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfRoot;

public interface ISsfDynamics
extends ISsfRoot {
    public int getInnovationsDim();

    public void V(int var1, FastMatrix var2);

    public void S(int var1, FastMatrix var2);

    public boolean hasInnovations(int var1);

    public boolean areInnovationsTimeInvariant();

    public void T(int var1, FastMatrix var2);

    public void TX(int var1, DataBlock var2);

    public void addSU(int var1, DataBlock var2, DataBlock var3);

    default public void TM(int pos, FastMatrix M) {
        M.applyByColumns(x -> this.TX(pos, (DataBlock)x));
    }

    default public void MTt(int pos, FastMatrix M) {
        M.applyByRows(x -> this.TX(pos, (DataBlock)x));
    }

    default public void TVT(int pos, FastMatrix M) {
        this.TM(pos, M);
        this.MTt(pos, M);
        SymmetricMatrix.reenforceSymmetry(M);
    }

    public void addV(int var1, FastMatrix var2);

    public void XT(int var1, DataBlock var2);

    default public void MT(int pos, FastMatrix M) {
        M.applyByRows(row -> this.XT(pos, (DataBlock)row));
    }

    default public void TtM(int pos, FastMatrix M) {
        M.applyByColumns(col -> this.XT(pos, (DataBlock)col));
    }

    public void XS(int var1, DataBlock var2, DataBlock var3);
}

