/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearsystem;

import java.util.function.Supplier;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearsystem.LS_Factory;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;

public interface LinearSystemSolver {
    public static LinearSystemSolver fastSolver() {
        return LS_Factory.FAST_FACTORY.get().get();
    }

    public static LinearSystemSolver robustSolver() {
        return LS_Factory.ROBUST_FACTORY.get().get();
    }

    public static void setFastSolver(Supplier<LinearSystemSolver> factory) {
        LS_Factory.FAST_FACTORY.set(factory);
    }

    public static void setRobustSolver(Supplier<LinearSystemSolver> factory) {
        LS_Factory.ROBUST_FACTORY.set(factory);
    }

    public void solve(FastMatrix var1, DataBlock var2) throws MatrixException;

    public void solve(FastMatrix var1, FastMatrix var2) throws MatrixException;
}

