/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.math.linearfilters.FilterSpec;
import jdplus.toolkit.base.api.math.linearfilters.HendersonSpec;
import jdplus.toolkit.base.api.math.linearfilters.LocalPolynomialFilterSpec;
import jdplus.toolkit.base.api.math.linearfilters.UserDefinedFilterSpec;
import jdplus.toolkit.base.api.math.linearfilters.UserDefinedSymmetricFilterSpec;
import jdplus.toolkit.base.core.math.linearfilters.Filtering;
import jdplus.toolkit.base.core.math.linearfilters.HendersonFilters;
import jdplus.toolkit.base.core.math.linearfilters.IFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiltering;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.LinearFilterException;
import jdplus.toolkit.base.core.math.linearfilters.LocalPolynomialFilters;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFiltering;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class FiltersToolkit {
    private static final Map<Class, Function<FilterSpec, IFiltering>> map = new HashMap<Class, Function<FilterSpec, IFiltering>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends FilterSpec> void register(Class<S> spec, Function<S, IFiltering> fn) {
        Map<Class, Function<FilterSpec, IFiltering>> map = FiltersToolkit.map;
        synchronized (map) {
            FiltersToolkit.map.put(spec, fn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends FilterSpec> void unregister(Class<S> spec) {
        Map<Class, Function<FilterSpec, IFiltering>> map = FiltersToolkit.map;
        synchronized (map) {
            FiltersToolkit.map.remove(spec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IFiltering of(FilterSpec spec) {
        Map<Class, Function<FilterSpec, IFiltering>> map = FiltersToolkit.map;
        synchronized (map) {
            Function<FilterSpec, IFiltering> fn = FiltersToolkit.map.get(spec.getClass());
            if (fn == null) {
                throw new LinearFilterException("Filter spec not registered");
            }
            return fn.apply(spec);
        }
    }

    public static double[] gain(IFilter filter) {
        DoubleUnaryOperator gainFunction = filter.gainFunction();
        int RES = 600;
        double[] g = new double[RES + 1];
        for (int i = 0; i <= RES; ++i) {
            g[i] = gainFunction.applyAsDouble((double)i * Math.PI / 600.0);
        }
        return g;
    }

    public static double varianceReduction(IFiniteFilter filter) {
        double s = 0.0;
        int l = filter.getLowerBound();
        int u = filter.getUpperBound();
        IntToDoubleFunction weights = filter.weights();
        for (int i = l; i <= u; ++i) {
            double w = weights.applyAsDouble(i);
            s += w * w;
        }
        return s;
    }

    public static double bias0(IFiniteFilter filter) {
        double s = 0.0;
        int l = filter.getLowerBound();
        int u = filter.getUpperBound();
        IntToDoubleFunction weights = filter.weights();
        for (int i = l; i <= u; ++i) {
            double w = weights.applyAsDouble(i);
            s += w;
        }
        return s;
    }

    public static double bias1(IFiniteFilter filter) {
        double s = 0.0;
        int l = filter.getLowerBound();
        int u = filter.getUpperBound();
        IntToDoubleFunction weights = filter.weights();
        for (int i = l; i <= u; ++i) {
            double w = (double)i * weights.applyAsDouble(i);
            s += w;
        }
        return s;
    }

    public static double bias2(IFiniteFilter filter) {
        double s = 0.0;
        int l = filter.getLowerBound();
        int u = filter.getUpperBound();
        IntToDoubleFunction weights = filter.weights();
        for (int i = l; i <= u; ++i) {
            double w = (double)(i * i) * weights.applyAsDouble(i);
            s += w;
        }
        return s;
    }

    public static double[] phase(IFilter filter) {
        DoubleUnaryOperator phaseFunction = filter.phaseFunction();
        int RES = 600;
        double[] g = new double[RES + 1];
        for (int i = 0; i <= RES; ++i) {
            g[i] = phaseFunction.applyAsDouble((double)i * Math.PI / 600.0);
        }
        return g;
    }

    @Generated
    private FiltersToolkit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        map.put(HendersonSpec.class, spec -> HendersonFilters.of((HendersonSpec)spec));
        map.put(LocalPolynomialFilterSpec.class, spec -> LocalPolynomialFilters.of((LocalPolynomialFilterSpec)spec));
        map.put(UserDefinedSymmetricFilterSpec.class, spec -> {
            if (spec instanceof UserDefinedSymmetricFilterSpec) {
                UserDefinedSymmetricFilterSpec uspec = (UserDefinedSymmetricFilterSpec)spec;
                return SymmetricFiltering.of(uspec.getCentralFilter(), uspec.getEndPointsFilters());
            }
            return null;
        });
        map.put(UserDefinedFilterSpec.class, spec -> {
            if (spec instanceof UserDefinedFilterSpec) {
                UserDefinedFilterSpec uspec = (UserDefinedFilterSpec)spec;
                return Filtering.of(uspec.getCentralFilter(), uspec.getLFilters(), uspec.getUFilters());
            }
            return null;
        });
    }

    @Deprecated
    public static final class FiniteFilters
    implements GenericExplorable {
        private final SymmetricFilter filter;
        private final IFiniteFilter[] afilters;
        private static final InformationMapping<FiniteFilters> MAPPING = new InformationMapping<FiniteFilters>(){

            public Class getSourceClass() {
                return FiniteFilters.class;
            }
        };

        public static final InformationMapping<FiniteFilters> getMapping() {
            return MAPPING;
        }

        public boolean contains(String id) {
            return MAPPING.contains(id);
        }

        public Map<String, Class> getDictionary() {
            LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
            MAPPING.fillDictionary(null, dic, true);
            return dic;
        }

        public <T> T getData(String id, Class<T> tclass) {
            return (T)MAPPING.getData((Object)this, id, tclass);
        }

        @Generated
        public static @NonNull Builder builder() {
            return new Builder();
        }

        @Generated
        public SymmetricFilter getFilter() {
            return this.filter;
        }

        @Generated
        public IFiniteFilter[] getAfilters() {
            return this.afilters;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FiniteFilters)) {
                return false;
            }
            FiniteFilters other = (FiniteFilters)o;
            SymmetricFilter this$filter = this.getFilter();
            SymmetricFilter other$filter = other.getFilter();
            if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
                return false;
            }
            return Arrays.deepEquals(this.getAfilters(), other.getAfilters());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SymmetricFilter $filter = this.getFilter();
            result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getAfilters());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "FiltersToolkit.FiniteFilters(filter=" + String.valueOf(this.getFilter()) + ", afilters=" + Arrays.deepToString(this.getAfilters()) + ")";
        }

        @Generated
        public FiniteFilters(SymmetricFilter filter, IFiniteFilter[] afilters) {
            this.filter = filter;
            this.afilters = afilters;
        }

        static {
            MAPPING.set("svariancereduction", Double.class, source -> FiltersToolkit.varianceReduction(source.filter));
            MAPPING.setArray("avariancereduction", 0, Double.class, (source, i) -> i < source.afilters[i].length() ? FiltersToolkit.varianceReduction(source.afilters[i]) : Double.NaN);
            MAPPING.set("sbias2", Double.class, source -> FiltersToolkit.bias2(source.filter));
            MAPPING.setArray("abias0", 0, Double.class, (source, i) -> i < source.afilters[i].length() ? FiltersToolkit.bias0(source.afilters[i]) : Double.NaN);
            MAPPING.setArray("abias1", 0, Double.class, (source, i) -> i < source.afilters[i].length() ? FiltersToolkit.bias1(source.afilters[i]) : Double.NaN);
            MAPPING.setArray("abias2", 0, Double.class, (source, i) -> i < source.afilters[i].length() ? FiltersToolkit.bias2(source.afilters[i]) : Double.NaN);
            MAPPING.set("sweights", double[].class, source -> source.filter.weightsToArray());
            MAPPING.setArray("aweights", 0, double[].class, (source, i) -> i < source.afilters[i].length() ? source.afilters[i].weightsToArray() : null);
            MAPPING.set("sgain", double[].class, source -> FiltersToolkit.gain(source.filter));
            MAPPING.setArray("again", 0, double[].class, (source, i) -> i < source.afilters[i].length() ? FiltersToolkit.gain(source.afilters[i]) : null);
            MAPPING.setArray("aphase", 0, double[].class, (source, i) -> i < source.afilters[i].length() ? FiltersToolkit.phase(source.afilters[i]) : null);
        }

        @Generated
        public static class Builder {
            @Generated
            private SymmetricFilter filter;
            @Generated
            private IFiniteFilter[] afilters;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder filter(SymmetricFilter filter) {
                this.filter = filter;
                return this;
            }

            @Generated
            public @NonNull Builder afilters(IFiniteFilter[] afilters) {
                this.afilters = afilters;
                return this;
            }

            @Generated
            public @NonNull FiniteFilters build() {
                return new FiniteFilters(this.filter, this.afilters);
            }

            @Generated
            public @NonNull String toString() {
                return "FiltersToolkit.FiniteFilters.Builder(filter=" + String.valueOf(this.filter) + ", afilters=" + Arrays.deepToString(this.afilters) + ")";
            }
        }
    }
}

