/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.tests;

import jdplus.sa.base.core.tests.AutoRegressiveSpectrumTest;
import jdplus.sa.base.core.tests.Friedman;
import jdplus.sa.base.core.tests.PeriodogramTest;
import jdplus.sa.base.core.tests.Qs;
import jdplus.sa.base.core.tests.SpectralPeaks;
import jdplus.sa.base.core.tests.TukeySpectrumPeaksTest;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.core.data.analysis.SmoothedPeriodogram;
import jdplus.toolkit.base.core.data.analysis.WindowFunction;
import jdplus.toolkit.base.core.modelling.DifferencingResult;

public class SeasonalityTests {
    public static final int MSHORT = 80;
    public static final int SHORT = 60;
    public static final int SPEC_LENGTH = 120;
    private DifferencingResult delta;
    private SmoothedPeriodogram btSpectrum;
    private TukeySpectrumPeaksTest tpeaks;
    private AutoRegressiveSpectrumTest arpeaks;
    private SpectralPeaks[] peaks;
    private StatisticalTest nptest;
    private StatisticalTest qs;
    private StatisticalTest periodogram;
    private int score;
    private int period;

    public static SeasonalityTests residualSeasonalityTest(DoubleSeq res, int period) {
        int n;
        StatisticalTest np;
        SeasonalityTests tests = new SeasonalityTests();
        tests.testResiduals(res, period);
        StatisticalTest qs = tests.getQs();
        if (qs != null && qs.isSignificant(0.01)) {
            ++tests.score;
        }
        if ((np = tests.getNonParametricTest()) != null && np.isSignificant(0.01)) {
            ++tests.score;
        }
        if (((n = tests.getDifferencing().getDifferenced().length()) >= 80 || period < 12 && n >= 60) && SpectralPeaks.hasSeasonalPeaks(tests.getSpectralPeaks())) {
            ++tests.score;
        }
        return tests;
    }

    public static SeasonalityTests seasonalityTest(DoubleSeq s, int period, int diff, boolean mean, boolean all) {
        int n;
        StatisticalTest np;
        if (period <= 1) {
            throw new TsException("Invalid frequnecy");
        }
        SeasonalityTests tests = new SeasonalityTests();
        tests.test(s, period, diff, mean);
        StatisticalTest qs = tests.getQs();
        if (qs != null && qs.isSignificant(0.01)) {
            ++tests.score;
            if (!all) {
                return tests;
            }
        }
        if ((np = tests.getNonParametricTest()) != null && np.isSignificant(0.01)) {
            ++tests.score;
            if (!all) {
                return tests;
            }
        }
        if (((n = tests.getDifferencing().getDifferenced().length()) >= 80 || period < 12 && n >= 60) && SpectralPeaks.hasSeasonalPeaks(tests.getSpectralPeaks())) {
            ++tests.score;
            if (!all) {
                return tests;
            }
        }
        return tests;
    }

    public void test(DoubleSeq input, int period, int ndiff, boolean mean) {
        this.delta = DifferencingResult.of((DoubleSeq)input, (int)period, (int)ndiff, (boolean)mean);
        this.period = period;
        this.clear();
    }

    private void testResiduals(DoubleSeq res, int period) {
        this.delta = DifferencingResult.of((DoubleSeq)res, (int)period, (int)0, (boolean)false);
        this.period = period;
        this.clear();
    }

    public DifferencingResult getDifferencing() {
        return this.delta;
    }

    public int getPeriod() {
        return this.period;
    }

    public StatisticalTest getNonParametricTest() {
        if (this.nptest == null) {
            Friedman friedman = new Friedman(this.delta.getDifferenced(), this.period);
            this.nptest = friedman.build();
        }
        return this.nptest;
    }

    public TukeySpectrumPeaksTest getTukeyPeaks() {
        if (this.tpeaks == null) {
            this.tpeaks = new TukeySpectrumPeaksTest();
            if (!this.tpeaks.test(this.delta.getDifferenced(), this.period)) {
                this.tpeaks = null;
            }
        }
        return this.tpeaks;
    }

    public SmoothedPeriodogram getSmoothedPeriodogram() {
        if (this.btSpectrum == null) {
            DoubleSeq d = this.delta.getDifferenced();
            int n = d.length();
            int wlen = 3 * n / 4 / this.period;
            if (wlen > 11) {
                wlen = 11;
            }
            this.btSpectrum = SmoothedPeriodogram.builder().data(d).windowFunction(WindowFunction.Tukey).windowLength(wlen * this.period).build();
        }
        return this.btSpectrum;
    }

    public AutoRegressiveSpectrumTest getArPeaks() {
        if (this.arpeaks == null) {
            this.arpeaks = new AutoRegressiveSpectrumTest();
            DoubleSeq dlast = this.delta.getDifferenced();
            if (!this.arpeaks.test(dlast, this.period)) {
                this.arpeaks = null;
            }
        }
        return this.arpeaks;
    }

    public SpectralPeaks[] getSpectralPeaks() {
        if (this.peaks == null) {
            AutoRegressiveSpectrumTest arPeaks = this.getArPeaks();
            TukeySpectrumPeaksTest tPeaks = this.getTukeyPeaks();
            if (arPeaks == null || tPeaks == null) {
                return null;
            }
            int[] a = arPeaks.seasonalPeaks(0.9, 0.99);
            int[] t = tPeaks.seasonalPeaks(0.9, 0.99);
            this.peaks = new SpectralPeaks[this.period / 2];
            for (int i = 0; i < this.peaks.length; ++i) {
                SpectralPeaks.AR ar = SpectralPeaks.AR.none;
                SpectralPeaks.Tukey tu = SpectralPeaks.Tukey.none;
                if (a != null) {
                    ar = SpectralPeaks.AR.fromInt(a[i]);
                }
                if (t != null) {
                    tu = SpectralPeaks.Tukey.fromInt(t[i]);
                }
                this.peaks[i] = new SpectralPeaks(ar, tu);
            }
        }
        return this.peaks;
    }

    public StatisticalTest getQs() {
        if (this.qs == null) {
            this.qs = new Qs(this.delta.getDifferenced(), this.period).autoCorrelationsCount(2).build();
        }
        return this.qs;
    }

    public StatisticalTest getPeriodogramTest() {
        if (this.periodogram == null) {
            PeriodogramTest test = new PeriodogramTest(this.delta.getDifferenced(), this.period);
            this.periodogram = test.buildF();
        }
        return this.periodogram;
    }

    public int getScore() {
        return this.score;
    }

    private void clear() {
        this.nptest = null;
        this.arpeaks = null;
        this.tpeaks = null;
        this.qs = null;
        this.periodogram = null;
        this.score = 0;
    }
}

