/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.stats;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.core.stats.InverseAutoCorrelations;
import jdplus.toolkit.base.core.stats.RobustStandardDeviationComputer;
import jdplus.toolkit.base.core.stats.tests.BowmanShenton;
import jdplus.toolkit.base.core.stats.tests.DoornikHansen;
import jdplus.toolkit.base.core.stats.tests.JarqueBera;
import jdplus.toolkit.base.core.stats.tests.Kurtosis;
import jdplus.toolkit.base.core.stats.tests.LjungBox;
import jdplus.toolkit.base.core.stats.tests.Skewness;
import jdplus.toolkit.base.core.stats.tests.TestOfRuns;
import jdplus.toolkit.base.core.stats.tests.TestOfUpDownRuns;
import lombok.Generated;

public final class Tests {
    public static double[] autocorrelations(double[] data, boolean mean, int n) {
        double[] iac = new double[n];
        DoubleSeq x = DoubleSeq.of((double[])data);
        IntToDoubleFunction fn = AutoCovariances.autoCorrelationFunction((DoubleSeq)x, (double)(mean ? x.average() : 0.0));
        for (int i = 1; i <= n; ++i) {
            iac[i - 1] = fn.applyAsDouble(i);
        }
        return iac;
    }

    public static double[] partialAutocorrelations(double[] data, boolean mean, int n) {
        DoubleSeq x = DoubleSeq.of((double[])data);
        IntToDoubleFunction fn = AutoCovariances.autoCorrelationFunction((DoubleSeq)x, (double)(mean ? x.average() : 0.0));
        return AutoCovariances.partialAutoCorrelations((IntToDoubleFunction)fn, (int)n);
    }

    public static double[] inverseAutocorrelations(double[] data, int nar, int n) {
        double[] iac = new double[n];
        IntToDoubleFunction fn = InverseAutoCorrelations.sampleInverseAutoCorrelationsFunction((DoubleSeq)DoubleSeq.of((double[])data), (int)nar);
        for (int i = 1; i <= n; ++i) {
            iac[i - 1] = fn.applyAsDouble(i);
        }
        return iac;
    }

    public static StatisticalTest skewness(double[] data) {
        return new Skewness(DoubleSeq.of((double[])data)).build();
    }

    public static StatisticalTest kurtosis(double[] data) {
        return new Kurtosis(DoubleSeq.of((double[])data)).build();
    }

    public static StatisticalTest bowmanShenton(double[] data) {
        return new BowmanShenton(DoubleSeq.of((double[])data)).build();
    }

    public static StatisticalTest doornikHansen(double[] data) {
        return new DoornikHansen(DoubleSeq.of((double[])data)).build();
    }

    public static StatisticalTest jarqueBera(double[] data, int k, boolean sample) {
        return new JarqueBera(DoubleSeq.of((double[])data)).degreeOfFreedomCorrection(k).correctionForSample(sample).build();
    }

    public static StatisticalTest testOfRuns(double[] data, boolean mean, boolean number) {
        TestOfRuns test = new TestOfRuns(DoubleSeq.of((double[])data)).useMean(mean);
        return number ? test.testNumber() : test.testLength();
    }

    public static StatisticalTest testOfUpDownRuns(double[] data, boolean number) {
        TestOfUpDownRuns test = new TestOfUpDownRuns(DoubleSeq.of((double[])data));
        return number ? test.testNumber() : test.testLength();
    }

    public static StatisticalTest ljungBox(double[] data, int k, int lag, int nhp, int sign, boolean mean) {
        return new LjungBox(DoubleSeq.of((double[])data), mean).autoCorrelationsCount(k).lag(lag).hyperParametersCount(nhp).sign(sign).build();
    }

    public static double mad(double[] data, double centile, boolean mdedianCorrected) {
        return RobustStandardDeviationComputer.mad((double)centile, (boolean)mdedianCorrected).compute(DoubleSeq.of((double[])data));
    }

    @Generated
    private Tests() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

