% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{calibrate.table}
\alias{calibrate.table}
\title{Make a table of calibrated dates}
\usage{
calibrate.table(
  y,
  er,
  lab = c(),
  cc = 1,
  BCAD = FALSE,
  postbomb = FALSE,
  cc.dir = c(),
  thiscurve = c(),
  is.F = FALSE,
  is.pMC = FALSE,
  deltaR = 0,
  deltaSTD = 0,
  prob = 0.95,
  prob.round = 1,
  age.round = 0,
  docx = c()
)
}
\arguments{
\item{y}{The radiocarbon dates}

\item{er}{The laboratory errors of the radiocarbon dates}

\item{lab}{The labels of the radiocarbon dates (if any)}

\item{cc}{The calibration curve to smooth. Calibration curve for 14C dates: 'cc=1' for IntCal20 (northern hemisphere terrestrial), 'cc=2' for Marine20 (marine), 'cc=3' for SHCal20 (southern hemisphere terrestrial). Alternatively, one can also write, e.g., "IntCal20", "Marine13". One can also make a custom-built calibration curve, e.g. using 'mix.ccurves()', and load this using 'cc=4'. In this case, it is recommended to place the custom calibration curve in its own directory, using 'cc.dir' (see below). Explanations of the numbers are provided in the table footer. If there is more than one cc provided, they will be printed in an extra table column.}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}. For the BCAD scale, BC ages are negative.}

\item{postbomb}{Use 'postbomb=TRUE' to get a postbomb calibration curve (default 'postbomb=FALSE'). For monthly data, type e.g. 'ccurve("sh1-2_monthly")'}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., 'cc.dir="ccurves"'.}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error). Defaults to c().}

\item{is.F}{Set this to TRUE if the provided age and error are in the F14C timescale.}

\item{is.pMC}{Set this to TRUE if the provided age and error are in the pMC timescale.}

\item{deltaR}{Age offset (e.g. for marine samples). If provided, the deltaR and deltaSTD values will be provided as an extra table column.}

\item{deltaSTD}{Uncertainty of the age offset (1 standard deviation). If provided, the deltaR and deltaSTD values will be provided as an extra table column.}

\item{prob}{Probability range which should be calculated. Default \code{prob=0.95}.}

\item{prob.round}{Rounding for reported probabilities. Defaults to 1 decimal.}

\item{age.round}{Rounding for ages. Defaults to 0 decimals.}

\item{docx}{By default, the table is written to your web browser. If you wish to write it to a MS-Word document instead, provide the file (with .docx extension) and its location here, e.g., \code{docx="C14_table.docx"}.}
}
\description{
Calibrate a number of radiocarbon dates and make a table containing the calibrated ranges (both highest posterior densities and quantiles).
}
\details{
Calibration is done taking into account calibration curves and any age offsets (deltaR, deltaSTD). The table will be displayed in an Internet browser, or alternatively saved to a .docx file.
}
\examples{
 calibrate.table(130, 20)
 data(shroud)
 calibrate.table(shroud$y, shroud$er, shroud$ID)
}
\author{
Maarten Blaauw
}
