% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R
\name{.prepareFileBackedRaster}
\alias{.prepareFileBackedRaster}
\title{Copy the file-backing of a file-backed Raster* object}
\usage{
.prepareFileBackedRaster(
  obj,
  repoDir = NULL,
  overwrite = FALSE,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  ...
)
}
\arguments{
\item{obj}{The raster object to save to the repository.}

\item{repoDir}{Character denoting an existing directory in which an artifact will be saved.}

\item{overwrite}{Logical. Should the raster be saved to disk, overwriting existing file.}

\item{drv}{If using a database backend, \code{drv} must be an object that
inherits from \code{DBIDriver} (e.g., \code{RSQLite::SQLite}).}

\item{conn}{an optional \code{DBIConnection} object, as returned by \code{dbConnect()}.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{...}{Not used}
}
\value{
A raster object and its newly located file backing.
Note that if this is a legitimate Cache repository, the new location
will be a subdirectory called \file{rasters/} of \file{repoDir/}.
If this is not a repository, the new location will be within \code{repoDir}.
}
\description{
Rasters are sometimes file-based, so the normal save and copy and assign
mechanisms in R don't work for saving, copying and assigning.
This function creates an explicit file copy of the file that is backing the raster,
and changes the pointer (i.e., \code{filename(object)}) so that it is pointing
to the new file.
}
\author{
Eliot McIntire
}
