% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilsRIVerification.R
\name{getRIMargins}
\alias{getRIMargins}
\title{Calculate uncertainty margins for a reference interval using the asymptotic method}
\usage{
getRIMargins(
  RI,
  RIperc = c(0.025, 0.975),
  UMprop = 0.9,
  lambda = 0,
  shift = 0,
  asymmetryCorr = FALSE,
  n = 120,
  verbose = TRUE
)
}
\arguments{
\item{RI}{(numeric) vector of length >= 2 representing the lower and upper limits of the reference interval.}

\item{RIperc}{(numeric) value specifying the percentiles, which define the reference interval (default \code{c(0.025, 0.975)})}

\item{UMprop}{(numeric) value between 0 and 1 representing the confidence level for the uncertainty margins.}

\item{lambda}{(numeric) value representing the power parameter for the Box-Cox transformation.}

\item{shift}{(numeric) value representing the shift parameter for the Box-Cox transformation.}

\item{asymmetryCorr}{(logical) value if the asymmetry correction shall be applied for extremely skewed distributions}

\item{n}{(numeric) value representing the sample size for which the sampling uncertainty shall be taken into account}

\item{verbose}{(logical) specifying if additional warning messages are printed}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{		(data.frame) containing the calculated uncertainty margins for the reference interval.
}\if{html}{\out{</div>}}
}
\description{
Calculate uncertainty margins for a reference interval using the asymptotic method
}
\examples{
\dontrun{
getRIMargins(RI = c(12, 65), lambda = 0, shift = 0)
getRIMargins(RI = c(12, 65), lambda = 1, shift = 0)
 the following examples should return NAs with and without asymmetry correction
 # Next examples should return NAs
getRIMargins(RI = c(78.6, 116.7), lambda = 0.30673426, shift = 120.898)
getRIMargins(RI = c(78.6, 116.7), lambda = 0.30673426, shift = 120.898, asymmetryCorr = FALSE)
}

}
\author{
Christopher Rank \email{christopher.rank@roche.com}
}
