% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaler_sim.R
\name{scaler_sim}
\alias{scaler_sim}
\title{Count Room Scaler Simulation}
\usage{
scaler_sim(true_bkg, true_samp, ct_time, trials = 1e+05)
}
\arguments{
\item{true_bkg}{True background count rate in counts per minute.}

\item{true_samp}{True sample count rate in counts per minute.}

\item{ct_time}{Count time in minutes.}

\item{trials}{Number of sample values, default = 1e5.}
}
\value{
A histogram of all trial results including limits for +/- 1 standard
deviation.
}
\description{
Returns a plotted distribution of results for a scaler model
based on the Poisson distribution. Inputs and outputs in counts per minute.
}
\examples{
scaler_sim(true_bkg = 5, true_samp = 10, ct_time = 1, trials = 1e5)
scaler_sim(true_bkg = 50, true_samp = 30, ct_time = 1, trials = 1e5)
}
\seealso{
Other rad measurements: 
\code{\link{air_dens_cf}()},
\code{\link{disk_to_disk_solid_angle}()},
\code{\link{neutron_geom_cf}()},
\code{\link{tau_estimate}()}
}
\concept{rad measurements}
