% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sliderCards.R
\name{elastiCard}
\alias{elastiCard}
\title{Hover elastic card container}
\usage{
elastiCard(
  ...,
  height.px = NULL,
  width.px = NULL,
  border.color = "white",
  border.width.px = 1,
  active.panel = 1
)
}
\arguments{
\item{...}{A list of image or content containers, where each item is a named vector or list specifying
properties like `bg` (background image URL), `icon` (Font Awesome icon name), `title`, `subtitle`,
`desc` (longer description), and `text.color`.
See examples for the expected structure of these item lists.}

\item{height.px}{Numeric. The fixed height of the entire `elastiCard` container in pixels. If `NULL`, the height adjusts automatically.}

\item{width.px}{Numeric. The fixed width of the entire `elastiCard` container in pixels. If `NULL`, the width adjusts automatically.}

\item{border.color}{Character string. The color of the border for the entire container (e.g., "white", "#RRGGBB").}

\item{border.width.px}{Numeric. The width of the border for the entire container in pixels.}

\item{active.panel}{Numeric. This parameter is retained for consistency with `flexCard` but
does not affect the hover-based behavior of `elastiCard`.}
}
\value{
An HTML `section` element containing multiple elastic cards with hover-based expansion functionality,
  suitable for inclusion in Shiny applications or R Markdown documents.
}
\description{
Creates an automatic elastic card holder, designed for showcasing images or navigation items
with a hover-based expansion effect, providing an engaging user experience.
}
\details{
The `elastiCard` function provides a dynamic display of multiple content cards that automatically
expand on hover. This effect is suitable for interactive galleries, team member profiles,
or feature lists where a preview is shown and more details emerge on user interaction.
Each card can display a background image, a title, a subtitle, a longer description,
and customizable text colors. The hover-based elasticity makes for an intuitive and responsive design.
}
\note{
Ensure that `shiny` is loaded if using this function within a Shiny application.
The `elastiCard` leverages CSS transitions for its hover effects, providing a smooth user experience.
For best visual results, provide images with consistent aspect ratios if using `bg` properties.
}
\section{Examples for r2resize}{

More examples and demo pages are located at this link -
\url{https://rpkg.net/package/r2resize}.
}

\examples{
\dontrun{
if (interactive()) {
  library(shiny)
  library(r2resize)
  library(htmltools)

  ui <- fluidPage(
    tags$h2("Hover Elastic Cards - Text Only"),
    elastiCard(
      item1 = c(
        icon = "brain",
        title = "Cognitive Science",
        subtitle = "Exploring the mind",
        desc = "Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.",
        text.color = "lightblue"
      ),
      item2 = c(
        title = "Neurobiology",
        subtitle = "The science of the nervous system",
        desc = "Ut enim ad minim veniam, quis nostrud exercitation ullamco
                laboris nisi ut aliquip ex ea commodo consequat.",
        text.color = "lightgreen"
      ),
      height.px = 300,
      width.px = 900,
      border.color = "gray",
      border.width.px = 1
    ),
    tags$br(),
    tags$h2("Hover Elastic Cards - With Background Images"),
    elastiCard(
      itemA = c(
        bg = "https://r2resize.obi.obianom.com/m/image1.jpg",
        icon = "chart-pie",
        title = "Data Visualization",
        subtitle = "Making data accessible",
        desc = "Duis aute irure dolor in reprehenderit in voluptate velit esse
                cillum dolore eu fugiat nulla pariatur."
      ),
      itemB = c(
        bg = "https://r2resize.obi.obianom.com/m/image2.jpg",
        title = "Machine Learning",
        subtitle = "AI-powered insights",
        desc = "Excepteur sint occaecat cupidatat non proident, sunt in culpa qui
                officia deserunt mollit anim id est laborum.",
        text.color = "white"
      ),
      itemC = c(
        bg = "https://r2resize.obi.obianom.com/m/image3.jpg",
        title = "Cloud Computing",
        subtitle = "Scalable solutions",
        desc = "Sed ut perspiciatis unde omnis iste natus error sit voluptatem
                accusantium doloremque laudantium.",
        text.color = "yellow"
      ),
      height.px = 350
    )
  )

  server <- function(input, output) {}

  shinyApp(ui, server)
}
}
}
\seealso{
\code{\link{flexCard}} for click-expandable flexible cards,
\code{\link{shinyExpandImage}} for elegant image viewing and resizing.

Other Image and Container Resizing Components: 
\code{\link{flexCard}()}
}
\concept{Image and Container Resizing Components}
