% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_functions.R
\name{qs_read}
\alias{qs_read}
\title{qs_read}
\usage{
qs_read(file,
         validate_checksum = qopt("validate_checksum"),
         nthreads = qopt("nthreads"))
}
\arguments{
\item{file}{The file name/path.}

\item{validate_checksum}{Whether to validate the stored checksum in the file (the initial value is FALSE).}

\item{nthreads}{The number of threads to use when reading data (the initial value is 1L). When TBB is not available, values greater than 1 emit a warning and fall back to 1.}
}
\value{
The object stored in \code{file}.
}
\description{
Reads an object that was saved to disk in the \code{qs2} format.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
         num = rnorm(1e3),
         char = sample(state.name, 1e3, replace=TRUE),
         stringsAsFactors = FALSE)
myfile <- tempfile()
qs_save(x, myfile)
x2 <- qs_read(myfile)
identical(x, x2) # returns TRUE
}
