% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pref_tools.R
\name{pref_get_items}
\alias{pref_get_items}
\title{Get the name of the item(s) assigned a specific rank, e.g., first.}
\usage{
pref_get_items(x, rank, drop = FALSE)
}
\arguments{
\item{x}{A vector of \code{\link{preferences}}.}

\item{rank}{A single integer, the rank which you would like to inspect.}

\item{drop}{When \code{FALSE} (default), blank preferences will remain. When
\code{TRUE}, blank preferences will be omitted.}
}
\value{
A list containing the name(s) of the item(s) ranked \code{rank} in each of
the preferences in \code{x}.
}
\description{
Get the name of the item(s) assigned a specific rank, e.g., first.
}
\examples{
# Get items ranked first
pref_get_items(preferences(c("a > b > c", "b = c > a")), rank = 1)
# Get items ranked second
pref_get_items(preferences(c("a > b > c", "b = c > a")), rank = 2)
# Get items ranked first, dropping blank preferences
pref_get_items(preferences(c("a > b > c", "", "b = c > a")), rank = 1, drop = TRUE)
}
