% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg_createTier.R
\name{tg_createTier}
\alias{tg_createTier}
\title{Interactively create a TextGrid tier}
\usage{
tg_createTier(
  sound,
  tierName,
  start = 0,
  end = 0,
  show = "wave",
  channel = 1,
  sampa2ipa = FALSE
)
}
\arguments{
\item{sound}{String giving the file name of a sound file with the .wav
extension.}

\item{tierName}{String giving the name of the tier.}

\item{start}{Start time (in seconds) of desired plotted area. Default is \code{0}.}

\item{end}{End time (in seconds) of desired plotted area. Default is \code{0}
(= the entire file).}

\item{show}{String giving the type of plot to show. Default is \code{wave},
another option is \code{spectrogram}. Note that spectrogram plotting is relatively
slow within this function.}

\item{channel}{Number indicating which audio channel to show. Default is \code{1}.}

\item{sampa2ipa}{Logical; should SAMPA transcriptions be converted to IPA?
Default is \code{FALSE}.}
}
\value{
A list object identical to a single tier created by
\code{\link[rPraat:tg.read]{rPraat::tg.read()}} when
loading TextGrid objects into R.
}
\description{
Function for creating TextGrid tiers called by \link{make_TextGrid}. Instead of
using this function directly, use \link{make_TextGrid}.
}
\examples{
\dontrun{
# Don't use directly
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/2.wav')
tg <- make_TextGrid(soundFile, tierNames='Mary')
# Follow the steps shown in the console

praatpicture(soundFile, tg_obj=tg)
}
}
