% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{check_compatibility}
\alias{check_compatibility}
\title{Check Data Compatibility}
\usage{
check_compatibility(historical_data, current_data, alpha = 0.05)
}
\arguments{
\item{historical_data}{Historical data}

\item{current_data}{Current data}

\item{alpha}{Significance level for compatibility test (default: 0.05)}
}
\value{
A list with compatibility test results
}
\description{
Performs a simple compatibility check between historical and current data
to help guide the choice of discounting parameter.
}
\examples{
set.seed(123)
historical <- rnorm(50, mean = 10, sd = 2)
current <- rnorm(30, mean = 10.5, sd = 2)

compatibility <- check_compatibility(historical, current)
print(compatibility)

}
