% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_software.R
\name{software_initializer}
\alias{software_initializer}
\title{Initialize software (Suspended)}
\usage{
software_initializer(
  software = c("Monolix", "nlmixr", "NONMEM"),
  mlx_path = NULL
)
}
\arguments{
\item{software}{(string) The software to be used for NN convertion; "Monolix","nlmixr", or "NONMEM"}

\item{mlx_path}{(string) Required if \emph{software="Monolix"}; path to Monolix location (under Windows usually 
C:/ProgramData/Lixoft/MonolixSuiteXXXX with XXXX as the version)}
}
\value{
Initialization of software
}
\description{
Initialize the pharmacometric software you want to use (Monolix, nlmixr or NONMEM). Must be used before nn_converter functions
can be used for Monolix and nlmixr.
}
\details{
For Monolix, the lixoftConnectors package is loaded. For loading, the path to the Monolix location (under Windows usually 
C:/ProgramData/Lixoft/MonolixSuiteXXXX with XXXX as the version) is required.
Note: nlmixr2 and lixoftConnectors share function \emph{getData}. If both, nlmixr and Monolix, get initialized, \emph{getData}
will be used from the package initialized second
}
\examples{
\dontrun{
software_initializer(software="NONMEM")
software_initializer(software="nlmixr")
software_initializer(software="Monolix",mlx_path="C:/ProgramData/Lixoft/MonolixSuite2021R2")
}
}
\author{
Dominic Bräm
}
