% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.multiData.R
\name{as.multiData}
\alias{as.multiData}
\title{Create a `multiData` object from multiple omicsData objects}
\usage{
as.multiData(
  ...,
  f_meta = NULL,
  sample_intersect = FALSE,
  match_samples = TRUE,
  keep_sample_info = FALSE,
  auto_fmeta = FALSE
)
}
\arguments{
\item{...}{two or more objects of type 'pepData', 'proData', 'metabData',
'lipidData', or 'nmrData', created by \code{\link{as.pepData}}}

\item{f_meta}{A data.frame containing sample and group information for all
omicsData objects supplied to the function.}

\item{sample_intersect}{logical indicator for whether only the samples that
are common across all datasets be kept in f_meta. See details for how
samples will be dropped.}

\item{match_samples}{logical indicator. If auto_fmeta = TRUE, whether to 
attempt to match the names in the sample columns in f_data across all
objects in an attempt to align them in f_meta. Defaults to TRUE.}

\item{keep_sample_info}{logical indicator for whether to attempt to append
sample information contained in the objects' f_data to the final f_meta via
a series of left joins. Defaults to FALSE.}

\item{auto_fmeta}{logical indicator for whether to attempt to automatically
construct f_meta from the objects' sample information. Defaults to FALSE.}
}
\value{
Object of class 'multiData' containing the omicsData objects, and the
 sample alignment information f_meta.
}
\description{
Create a `multiData` object from multiple omicsData objects
}
\details{
Object limits: Currently, as.multiData accepts at most one object
from each of classes 'pepData/proData', 'metabData', 'nmrData', and at most
two objects of class 'lipidData'.

\code{sample_intersect} will auto-align samples that occur in all datasets.
Specifically, it creates a vector of all samples that are common across all
datasets, and simply creates an f_meta by copying this vector for each dataset
and column-binding them.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(pmartRdata)

# Combine metabolomics and protein object into multidata, both must be log2
# and normalized.
mymetab <- edata_transform(omicsData = metab_object, data_scale = "log2")
mymetab <- normalize_global(omicsData = mymetab, subset_fn = "all",
                            norm_fn = "median", apply_norm = TRUE)

mypro <- pro_object

# Combine without specifically supplying f_meta, either directly, or as one
# of the f_datas in any object.
mymultidata <- as.multiData(mymetab, mypro, auto_fmeta = TRUE, sample_intersect = TRUE)

# Manually supply an f_meta
f_meta <- data.frame(check.names = FALSE, 
  "Proteins" = mypro$f_data$SampleID[match(mymetab$f_data$SampleID, mypro$f_data$SampleID)],
  "Metabolites" = mymetab$f_data$SampleID,
  "Condition" = mymetab$f_data$Phenotype[match(mymetab$f_data$SampleID, mypro$f_data$SampleID)]
)

mymultidata <- as.multiData(mymetab, mypro, f_meta = f_meta)
# remove samples that are not common across all data.
mymultidata <- as.multiData(mymetab, mypro, f_meta = f_meta, sample_intersect = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{combine_omicsData}} if you want to combine lipidData
 objects before providing them to as.multiData.
}
