% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cal_cor_pleiotropic_h2_single.R
\name{Cal_cor_pleiotropic_h2_single}
\alias{Cal_cor_pleiotropic_h2_single}
\title{Compute single pleioh2g for target disease before correction with referred disease index in the rg matrix}
\usage{
Cal_cor_pleiotropic_h2_single(rg_mat, h2g_T_single, plei_h2_idx)
}
\arguments{
\item{rg_mat}{genetic correlation matrix.}

\item{h2g_T_single}{heritability for target diseases.}

\item{plei_h2_idx}{index of the target disease in the rg_mat.}
}
\value{
pleioh2g value for the target disease before correction
}
\description{
This function computes pleioh2g for the target disease before correction.
}
\examples{
data(Results_full_rg_15D)
data(h2_vector_15D)
plei_h2_idx<-1
h2g_T_single<-h2_vector_15D[plei_h2_idx]
Cal_cor_pleiotropic_h2_single(Results_full_rg_15D,h2g_T_single,plei_h2_idx)
}
