% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_ppverse.R
\name{install_ppverse}
\alias{install_ppverse}
\alias{pkgs_ppverse}
\title{Install additional packages from the piecepackr universe}
\usage{
install_ppverse(
  pkgs = pkgs_ppverse(free_libre_only),
  ...,
  dependencies = TRUE,
  free_libre_only = TRUE
)

pkgs_ppverse(free_libre_only = TRUE)
}
\arguments{
\item{pkgs}{Packages to install. Passed to \code{\link[utils:install.packages]{utils::install.packages()}}.}

\item{...}{Passed to \code{\link[utils:install.packages]{utils::install.packages()}}.}

\item{dependencies}{Logical indicating whether to install dependencies of \code{pkgs}. Passed to \code{\link[utils:install.packages]{utils::install.packages()}}.}

\item{free_libre_only}{Flag to only include packages that are Free/Libre Open Source.}
}
\description{
Uses \code{\link[utils:install.packages]{utils::install.packages()}} to install additional R packages
from the piecepackr universe \url{https://piecepackr.r-universe.dev/builds}.
\code{pkgs_ppverse()} returns a character vector of R packages
in the piecepackr universe.
}
\examples{
pkgs_ppverse()
\dontrun{# Installs non-CRAN packages from the piecepackr universe
  install_ppverse()
}
}
