% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lin.cor.R
\name{lin.cor}
\alias{lin.cor}
\title{Linear Correlation}
\usage{
lin.cor(
  x,
  y = NULL,
  method = "pearson",
  test.na = FALSE,
  epsilon = 1e-05,
  num.threads = NULL
)
}
\arguments{
\item{x}{a numeric \code{vector}, \code{matrix}, or \code{data.frame}.}

\item{y}{a numeric \code{vector} that should be correlated with \code{x}.}

\item{method}{the method to compute the linear correlation between \code{x} and \code{y}.}

\item{test.na}{a boolean value indicating whether input data should be checked for \code{NA} values.}

\item{epsilon}{a small value to address cases where division by zero occurs. Default is `0.00001`.
This is only used for `method = "pearson"`.}

\item{num.threads}{an integer specifying the number of threads to be used for parallel computations.
Default is `NULL`, which uses the value from the `RCPP_PARALLEL_NUM_THREADS` environment variable or `2` if not set.}
}
\description{
This function computed the linear correlation between two vectors or a correlation matrix for an input matrix.

The following methods to compute linear correlations are implemented in this function:
}
\details{
\itemize{
  \item \code{method = "pearson"} : Pearson's correlation coefficient (centred).
  \item \code{method = "pearson2"} : Pearson's uncentred correlation coefficient.
  \item \code{method = "sq_pearson"} . Squared Pearson's correlation coefficient.
  \item \code{method = "kendall"} : Kendall's correlation coefficient.
  \item \code{method = "spearman"} : Spearman's correlation coefficient.
  } 
  
 Further Details:
  
 \itemize{
 \item \emph{Pearson's correlation coefficient (centred)} : 
 }
}
\author{
Hajk-Georg Drost
}
