% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_match.R
\name{get_ambiguous_matches}
\alias{get_ambiguous_matches}
\title{Retrieve Ambiguous Match Information}
\usage{
get_ambiguous_matches(
  match_result,
  type = c("genus", "species", "infraspecies", "all"),
  save_to_file = FALSE,
  output_dir = tempdir()
)
}
\arguments{
\item{match_result}{A tibble returned by matching functions such as
\code{\link{matching_threatenedperu}} or internal matching functions.}

\item{type}{Character. Type of ambiguous matches to retrieve:
\itemize{
  \item \code{"genus"} (default): Ambiguous genus-level matches
  \item \code{"species"}: Ambiguous species-level matches
  \item \code{"infraspecies"}: Ambiguous infraspecies-level matches (includes level 2)
  \item \code{"all"}: All types of ambiguous matches
}}

\item{save_to_file}{Logical. If TRUE, saves results to a CSV file.
Default is FALSE (CRAN compliant - no automatic file writing).}

\item{output_dir}{Character. Directory to save the file if save_to_file = TRUE.
Defaults to \code{tempdir()} for safe file operations.}
}
\value{
A tibble with ambiguous match details, or NULL if no ambiguous matches exist.
Columns depend on the match type but typically include original names,
matched names, and distance metrics.
}
\description{
Extracts information about ambiguous matches (multiple candidates with
tied distances) from matching results. This is useful for quality control
and manual curation of uncertain matches.
}
\details{
During fuzzy matching, multiple candidates may have identical string distances,
making the choice of match ambiguous. The matching algorithm automatically
selects the first candidate, but this function allows you to:
\itemize{
  \item Review all ambiguous matches for quality control
  \item Export them for manual curation
  \item Make informed decisions about match quality
}
}
\section{File Output}{

When \code{save_to_file = TRUE}, a timestamped CSV file is created:
\itemize{
  \item Filename format: "threatenedperu_ambiguous_[type]_[timestamp].csv"
  \item Location: \code{output_dir} (defaults to tempdir())
  \item Contains all ambiguous matches with metadata
}
}

