% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{writeResults}
\alias{writeResults}
\title{Write coordinates and cluster assignment to a CSV file}
\usage{
writeResults(
  space1,
  cov = NULL,
  covInv = NULL,
  exp = NULL,
  space2,
  space2.cov = NULL,
  space2.covInv = NULL,
  space2.exp = NULL,
  settings,
  filename,
  user_dist = NULL,
  getCoords.space1 = normCoords,
  getCoords.space2 = rawCoords
)
}
\arguments{
\item{space1}{cluster space matrix}

\item{cov}{covariance matrix}

\item{covInv}{inverse covariance matrix}

\item{exp}{observable reference value (e.g. experimental measurement)}

\item{space2}{space2 matrix}

\item{space2.cov}{covariance matrix}

\item{space2.covInv}{inverse covariance matrix}

\item{space2.exp}{observable reference value (e.g. experimental measurement)}

\item{settings}{list specifying parameters usually selected in the app}

\item{filename}{path to write the results file to}

\item{user_dist}{input distance matrix (optional)}

\item{getCoords.space1}{function to calculate coordinates on clustering space}

\item{getCoords.space2}{function to calculate coordinates on linked space}
}
\value{
No return value, called for writing file
}
\description{
For working with the results outside the app.
Settings used: metric, linkage, k
}
\examples{
file<-tempfile()
writeResults(space1 = Bikes$space1, space2 = Bikes$space2,
settings = list(metric="euclidean",linkage="ward.D2",k=4), filename = file)
file.remove(file)


}
