% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_consistency.R
\name{check_positional_bias}
\alias{check_positional_bias}
\title{Check positional bias and bootstrap consistency reliability}
\usage{
check_positional_bias(
  consistency,
  n_boot = 1000,
  conf_level = 0.95,
  seed = NULL
)
}
\arguments{
\item{consistency}{Either:
\itemize{
\item A list returned by \code{compute_reverse_consistency()} that
contains a \code{$details} tibble; or
\item A tibble/data frame with columns
\code{key}, \code{ID1_main}, \code{ID2_main},
\code{better_id_main}, \code{ID1_rev}, \code{ID2_rev},
\code{better_id_rev}, and \code{is_consistent}.
}}

\item{n_boot}{Integer, number of bootstrap resamples for estimating the
distribution of the overall consistency proportion. Default is 1000.}

\item{conf_level}{Confidence level for the bootstrap interval. Default is
0.95.}

\item{seed}{Optional integer seed for reproducible bootstrapping. If
\code{NULL} (default), the current RNG state is used.}
}
\value{
A list with two elements:
\describe{
\item{summary}{A tibble with:
\itemize{
\item \code{n_pairs}: number of unordered pairs
\item \code{prop_consistent}: observed proportion of consistent pairs
\item \code{boot_mean}: mean of bootstrap consistency proportions
\item \code{boot_lwr}, \code{boot_upr}: bootstrap confidence interval
\item \code{p_sample1_main}: p-value from a binomial test for the
null hypothesis that SAMPLE_1 wins 50\\% of the time in the
main (forward) comparisons
\item \code{p_sample1_rev}: analogous p-value for the reverse
comparisons
\item \code{p_sample1_overall}: p-value from a binomial test for
the null that position 1 wins 50\\% of the time across
\emph{all} (forward + reverse) comparisons
\item \code{total_pos1_wins}: total number of wins by position 1
across forward + reverse comparisons
\item \code{total_comparisons}: total number of valid forward +
reverse comparisons included in the overall test
\item \code{n_inconsistent}: number of pairs with inconsistent
forward vs. reverse outcomes
\item \code{n_inconsistent_pos1_bias}: among inconsistent pairs, how
many times the winner is in position 1 in both directions
\item \code{n_inconsistent_pos2_bias}: analogous for position 2
}
}
\item{details}{The input \code{details} tibble augmented with:
\itemize{
\item \code{winner_pos_main}: \code{"pos1"} or \code{"pos2"} (or
\code{NA}) indicating which position won in the main direction
\item \code{winner_pos_rev}: analogous for the reversed direction
\item \code{is_pos1_bias}: logical; \code{TRUE} if the pair is
inconsistent and position 1 wins in both directions
\item \code{is_pos2_bias}: analogous for position 2
}
}
}
}
\description{
This function diagnoses positional bias in LLM-based paired comparison data
and provides a bootstrapped confidence interval for the overall consistency
of forward vs. reverse comparisons.
}
\details{
It is designed to work with the output of
\code{\link{compute_reverse_consistency}}, but will also accept a tibble
that looks like its \code{$details} component.
}
\examples{
# Simple synthetic example
main <- tibble::tibble(
  ID1       = c("S1", "S1", "S2"),
  ID2       = c("S2", "S3", "S3"),
  better_id = c("S1", "S3", "S2")
)

rev <- tibble::tibble(
  ID1       = c("S2", "S3", "S3"),
  ID2       = c("S1", "S1", "S2"),
  better_id = c("S1", "S3", "S2")
)

rc <- compute_reverse_consistency(main, rev)
rc$summary

bias <- check_positional_bias(rc)
bias$summary

}
