% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_metamodel.R
\name{predict_metamodel}
\alias{predict_metamodel}
\title{Predict using a fitted metamodel}
\usage{
predict_metamodel(model = NULL, inputs = NULL, output_type = "vector")
}
\arguments{
\item{model}{model object. Built using a function from the PACHECK package.}

\item{inputs}{dataframe or vector. When choosing a vector in the case of a three-variable model: the first, second, third, and fourth value represent the input for the first, second, third, and FIRST variable, respectively. Default gives the predictions based on the training data.}

\item{output_type}{character. Choose an output: 'dataframe', 'long_df' (long data.frame) or 'vector'.}
}
\value{
returns a vector of the the predictions ('vector' output_type) or the parameter values used for the predictions and the predictions ('dataframe' or 'long_df' output_type).
}
\description{
Predict using a fitted metamodel
}
\examples{
#Making 3 predictions for a two-variable metamodel,
# using a vector as input, and yielding a dataframe as output.
data(df_pa)
lm_fit = fit_lm_metamodel(df = df_pa,
                 y_var = "inc_qaly",
                 x_vars = c("p_pfsd", "p_pdd")
                 )

vec = c(0.1,0.2,0.08,0.15,0.06,0.25)

predict_metamodel(model = lm_fit,
                 inputs = vec,
                 output_type = "dataframe"
                 )
}
